#ifndef CRYSATPTEST_MSG_DEFS_H
#define CRYSATPTEST_MSG_DEFS_H

/*
   *  Object          : crysatptest_msg_defs.h
   *  State           :  %state%
   *  Creation date   :  Wed Nov 23 17:26:15 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief this file containes the definitions for the HOST-SEP protocl.
   *         
   *
   *  \version crysatptest_msg_defs.h#1:csrc:3
   *  \author avis
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Includes *****************************/
#include "msg_defs.h"
#include "ExtApp_CRYS_Defines.h"

/************************ Defines ******************************/

/* HOST AES TEST COMMAND */


/* offsets of the parameters inside message */
#define DX_EXT_SEP_HOST_AES_NOINTEG_IVCOUNTER_OFFSET       (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_AES_IVCOUNTER_OFFSET)
#define DX_EXT_SEP_HOST_AES_NOINTEG_KEY_OFFSET             (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_AES_KEYPTR_OFFSET)       
#define DX_EXT_SEP_HOST_AES_NOINTEG_KEY_TYPE_OFFSET        (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_AES_KEYTYPE_OFFSET)
#define DX_EXT_SEP_HOST_AES_NOINTEG_ENC_DEC_OFFSET         (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_AES_ENCDEC_OFFSET)
#define DX_EXT_SEP_HOST_AES_NOINTEG_MODE_OFFSET            (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_AES_MODE_OFFSET)
#define DX_EXT_SEP_HOST_AES_NOINTEG_ISSECRETKEY_OFFSET     (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_AES_ISSECRETKEY_OFFSET)
#define DX_EXT_SEP_HOST_AES_NOINTEG_OUTPUTLOCATION_OFFSET  (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_AES_OUTPUTLOCATION_OFFSET)
#define DX_EXT_SEP_HOST_AES_NOINTEG_DATA_IN_OFFSET         (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_AES_DATAIN_OFFSET)
#define DX_EXT_SEP_HOST_AES_NOINTEG_DATASIZE_IN_OFFSET     (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_AES_DATAINSIZE_OFFSET)
#define DX_EXT_SEP_HOST_AES_NOINTEG_DATASIZE_EXP_OFFSET    (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_AES_DATAEXPSIZE_OFFSET)


/* offset to put return parameter */
#define DX_SEP_HOST_SEP_AES_MSG_RPLY_DATA_OUT_OFFSET		DX_SEP_HOST_SEP_BASE_MSG_OFFSET

/* AES test functions */
DxUint32_t DX_SEP_PARSER_AESNotIntegratedTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_AESIntegratedTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_AES_MACNonIntegratedTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_AES_XCBC_CMACNonIntegratedTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_AES_MACIntegratedTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_AES_XCBC_CMACIntegratedTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_AES_KeyWrapUnwarp(DxUint32_t* msg);

/******************* DES *********************************/
/*********************************************************/

/* HOST DES TEST COMMAND */


/* offsets of the parameters inside message */
#define DX_EXT_SEP_HOST_DES_NOINTEG_IVCOUNTER_OFFSET       (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DES_IVCOUNTER_OFFSET)
#define DX_EXT_SEP_HOST_DES_NOINTEG_KEY_OFFSET             (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DES_KEYPTR_OFFSET)       
#define DX_EXT_SEP_HOST_DES_NOINTEG_KEY_TYPE_OFFSET        (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DES_KEYTYPE_OFFSET)
#define DX_EXT_SEP_HOST_DES_NOINTEG_ENC_DEC_OFFSET         (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DES_ENCDEC_OFFSET)
#define DX_EXT_SEP_HOST_DES_NOINTEG_MODE_OFFSET            (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DES_MODE_OFFSET)
#define DX_EXT_SEP_HOST_DES_NOINTEG_OUTPUTLOCATION_OFFSET  (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DES_OUTPUTLOCATION_OFFSET)
#define DX_EXT_SEP_HOST_DES_NOINTEG_DATA_IN_OFFSET         (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DES_DATAIN_OFFSET)
#define DX_EXT_SEP_HOST_DES_NOINTEG_DATASIZE_IN_OFFSET     (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DES_DATAINSIZE_OFFSET)
#define DX_EXT_SEP_HOST_DES_NOINTEG_DATASIZE_EXP_OFFSET    (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DES_DATAEXPSIZE_OFFSET)


/* offset to put return parameter */
#define DX_SEP_HOST_SEP_DES_MSG_RPLY_DATA_OUT_OFFSET		DX_SEP_HOST_SEP_BASE_MSG_OFFSET

/* DES test functions */
DxUint32_t DX_SEP_PARSER_DESNotIntegratedTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_DESIntegratedTest(DxUint32_t* msg);

/******************* HASH *********************************/
/*********************************************************/

/* HOST HASH TEST COMMAND */

/* offsets of the parameters inside message */
#define DX_EXT_SEP_HOST_HASH_MODE_OFFSET            (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_HASH_MODE_OFFSET)
#define DX_EXT_SEP_HOST_HASH_DATA_IN_OFFSET         (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_HASH_DATAIN_OFFSET)
#define DX_EXT_SEP_HOST_HASH_DATASIZE_IN_OFFSET     (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_HASH_DATAINSIZE_OFFSET)
#define DX_EXT_SEP_HOST_HASH_DATASIZE_EXP_OFFSET    (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_HASH_DATAEXPSIZE_OFFSET)


/* offset to put return parameter */
#define DX_SEP_HOST_SEP_HASH_MSG_RPLY_DATA_OUT_OFFSET		DX_SEP_HOST_SEP_BASE_MSG_OFFSET

/* HASH test functions */
DxUint32_t DX_SEP_PARSER_HASHNotIntegratedTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_HASHIntegratedTest(DxUint32_t* msg);


/******************* HMAC *********************************/
/*********************************************************/

/* HOST HMAC TEST COMMAND */

/* offsets of the parameters inside message */
#define DX_EXT_SEP_HOST_HMAC_KEYSIZE_OFFSET            (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_HMAC_KEYSIZE_OFFSET)
#define DX_EXT_SEP_HOST_HMAC_MODE_OFFSET               (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_HMAC_MODE_OFFSET)
#define DX_EXT_SEP_HOST_HMAC_KEYPTR_OFFSET             (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_HMAC_KEYPTR_OFFSET)
#define DX_EXT_SEP_HOST_HMAC_DATASIZE_IN_OFFSET        (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_HMAC_DATAINSIZE_OFFSET)
#define DX_EXT_SEP_HOST_HMAC_DATASIZE_EXP_OFFSET       (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_HMAC_DATAEXPSIZE_OFFSET)


/* offset to put return parameter */
#define DX_SEP_HOST_SEP_HMAC_MSG_RPLY_DATA_OUT_OFFSET		DX_SEP_HOST_SEP_BASE_MSG_OFFSET

/* HASH test functions */
DxUint32_t DX_SEP_PARSER_HMACNotIntegratedTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_HMACIntegratedTest(DxUint32_t* msg);

/******************* RC4 *********************************/
/*********************************************************/

/* HOST RC4 TEST COMMAND */

/* message length except buffers */
#define	DX_SEP_HOST_SEP_RC4_MSG_LENGTH_IN_WORDS	DX_EXT_SEP_HOST_RC4_KEYPTR_OFFSET /* msg len in words =  */


/* offsets of the parameters inside message */
#define DX_EXT_SEP_HOST_RC4_KEYSIZE_OFFSET            (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RC4_KEYSIZE_OFFSET)
#define DX_EXT_SEP_HOST_RC4_ENCDEC_OFFSET             (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RC4_ENCDEC_OFFSET)
#define DX_EXT_SEP_HOST_RC4_OUTPUTLOCATION_OFFSET     (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RC4_OUTPUTLOCATION_OFFSET)
#define DX_EXT_SEP_HOST_RC4_DATASIZE_IN_OFFSET        (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RC4_DATAINSIZE_OFFSET)
#define DX_EXT_SEP_HOST_RC4_DATASIZE_EXP_OFFSET       (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RC4_DATAEXPSIZE_OFFSET)
#define DX_EXT_SEP_HOST_RC4_KEYPTR_OFFSET             (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RC4_KEYPTR_OFFSET)


/* offset to put return parameter */
#define DX_SEP_HOST_SEP_RC4_MSG_RPLY_DATA_OUT_OFFSET		DX_SEP_HOST_SEP_BASE_MSG_OFFSET

/* RC4 test functions */
DxUint32_t DX_SEP_PARSER_RC4NotIntegratedTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RC4IntegratedTest(DxUint32_t* msg);


/******************* RSA *********************************/
/*********************************************************/

/* HOST RSA TEST COMMAND */

/* offsets of the parameters inside message */
#define DX_EXT_SEP_HOST_RSA_DATASIZE_IN_OFFSET          (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_DATASIZE_IN_OFFSET)
#define DX_EXT_SEP_HOST_RSA_PUBEXPONENTSIZE_OFFSET      (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_PUBEXPONENTSIZE_OFFSET)
#define DX_EXT_SEP_HOST_RSA_PRIVEXPONENTSIZE_OFFSET     (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_PRIVEXPONENTSIZE_OFFSET)
#define DX_EXT_SEP_HOST_RSA_KEYSIZE_OFFSET              (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_KEYSIZE_OFFSET)
#define DX_EXT_SEP_HOST_RSA_CRTMODE_OFFSET              (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_CRTMODE_OFFSET)
#define DX_EXT_SEP_HOST_RSA_KEYGENTYPE_OFFSET           (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_KEYGENTYPE_OFFSET)
#define DX_EXT_SEP_HOST_RSA_HASHMODE_OFFSET             (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_HASHMODE_OFFSET)
#define DX_EXT_SEP_HOST_RSA_SALTLENGTH_OFFSET           (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_SALTLENGTH_OFFSET)
#define DX_EXT_SEP_HOST_RSA_PSIZE_OFFSET                (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_PSIZE_OFFSET)
#define DX_EXT_SEP_HOST_RSA_QSIZE_OFFSET                (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_QSIZE_OFFSET)
#define DX_EXT_SEP_HOST_RSA_dPSIZE_OFFSET               (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_dPSIZE_OFFSET)
#define DX_EXT_SEP_HOST_RSA_dQSIZE_OFFSET               (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_dQSIZE_OFFSET)
#define DX_EXT_SEP_HOST_RSA_qInvSIZE_OFFSET             (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_qInvSIZE_OFFSET)
#define DX_EXT_SEP_HOST_RSA_PubExponent_OFFSET            (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RSA_PubExponent_OFFSET)

/* all buffers has the same maximal length = max modulus size = RSA_BufferMaxLength/4 */
#define DX_EXT_SEP_HOST_RSA_PrivExponent_OFFSET      DX_EXT_SEP_HOST_RSA_PubExponent_OFFSET + RSA_BufferMaxLength/4
#define DX_EXT_SEP_HOST_RSA_Modulus_OFFSET           DX_EXT_SEP_HOST_RSA_PrivExponent_OFFSET + RSA_BufferMaxLength/4
#define DX_EXT_SEP_HOST_RSA_P_OFFSET				 DX_EXT_SEP_HOST_RSA_Modulus_OFFSET + RSA_BufferMaxLength/4
#define DX_EXT_SEP_HOST_RSA_Q_OFFSET                 DX_EXT_SEP_HOST_RSA_P_OFFSET + RSA_BufferMaxLength/4
#define DX_EXT_SEP_HOST_RSA_dP_OFFSET				 DX_EXT_SEP_HOST_RSA_Q_OFFSET + RSA_BufferMaxLength/4
#define DX_EXT_SEP_HOST_RSA_dQ_OFFSET                DX_EXT_SEP_HOST_RSA_dP_OFFSET + RSA_BufferMaxLength/4
#define DX_EXT_SEP_HOST_RSA_qInv_OFFSET              DX_EXT_SEP_HOST_RSA_dQ_OFFSET + RSA_BufferMaxLength/4
#define DX_EXT_SEP_HOST_RSA_DataIn_OFFSET            DX_EXT_SEP_HOST_RSA_qInv_OFFSET + RSA_BufferMaxLength/4
#define DX_EXT_SEP_HOST_RSA_DataExpected_OFFSET      DX_EXT_SEP_HOST_RSA_DataIn_OFFSET + RSA_BufferMaxLength/4



/* offset to put return parameter */
#define DX_SEP_HOST_SEP_RSA_MSG_RPLY_DATA_OUT_OFFSET		DX_SEP_HOST_SEP_BASE_MSG_OFFSET

/* RSA test functions */
DxUint32_t DX_SEP_PARSER_RSA_PRIME_EncDecTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RSA_PKCS1v15_EncDec(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RSA_PKCS1v15_NonIntegrate_SignVerify(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RSA_PKCS1v15_Integrate_SignVerify(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RSA_OAEP_EncDec(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RSA_PSS_NonIntegrate_SignVerify(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RSA_PSS_Integrate_SignVerify(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RSA_PKCS1v15_ExternalHash_SignVerify (DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RSA_PRIME_SignVerifyTest(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RSA_PSS_ExternalHash_SignVerify (DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RSA_Get_PrivAndPubKey(DxUint32_t* msg);
/******************* ECC *********************************/
/*********************************************************/

/* HOST ECC TEST COMMAND */

/* offsets of the parameters inside message */
#define DX_EXT_SEP_HOST_ECC_DATASIZE_IN_OFFSET		(DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_DATASIZE_IN_OFFSET)
#define DX_EXT_SEP_HOST_ECC_SIGNATURESIZE_OFFSET	(DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_SIGNATURESIZE_OFFSET)
#define DX_EXT_SEP_HOST_ECC_KEYGENTYPE_OFFSET		(DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_KEYGENTYPE_OFFSET)
#define DX_EXT_SEP_HOST_ECC_DOMAINID_OFFSET			(DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_DOMAINID_OFFSET)
#define DX_EXT_SEP_HOST_ECC_PUBLICKEYSIZE_OFFSET	(DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_PUBLICKEYSIZE_OFFSET)
#define DX_EXT_SEP_HOST_ECC_PRIVKEYSIZE_OFFSET		(DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_PRIVKEYSIZE_OFFSET)
#define DX_EXT_SEP_HOST_ECC_HASH_OFFSET				(DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_HASH_OFFSET)
#define DX_EXT_SEP_HOST_ECC_DataIn_OFFSET           (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_DataIn_OFFSET)


#define	DX_EXT_SEP_HOST_ECC_DH_KEYGENTYPE_OFFSET         (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_DH_KEYGENTYPE_OFFSET)
#define	DX_EXT_SEP_HOST_ECC_DH_DOMAINID_OFFSET           (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_DH_DOMAINID_OFFSET)
#define	DX_EXT_SEP_HOST_ECC_DH_PUBLICKEYSIZE1_OFFSET     (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_DH_PUBLICKEYSIZE1_OFFSET)
#define	DX_EXT_SEP_HOST_ECC_DH_PRIVKEYSIZE1_OFFSET       (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_DH_PRIVKEYSIZE1_OFFSET)
#define	DX_EXT_SEP_HOST_ECC_DH_PUBLICKEYSIZE2_OFFSET     (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_DH_PUBLICKEYSIZE2_OFFSET)
#define	DX_EXT_SEP_HOST_ECC_DH_PRIVKEYSIZE2_OFFSET       (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_DH_PRIVKEYSIZE2_OFFSET)
#define	DX_EXT_SEP_HOST_ECC_DH_MaxSecretKeySize_OFFSET   (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_DH_MaxSecretKeySize_OFFSET)
#define	DX_EXT_SEP_HOST_ECC_DH_PublKey1_OFFSET           (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_ECC_DH_PublKey1_OFFSET)


/* offset to put return parameter */
#define DX_SEP_HOST_SEP_ECC_MSG_RPLY_DATA_OUT_OFFSET		DX_SEP_HOST_SEP_BASE_MSG_OFFSET

/* ECC functions */
DxUint32_t DX_SEP_PARSER_ECC_ECDSA_NonIntegratedSignVerify(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_ECC_ECDSA_IntegratedSignVerify(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_ECC_DH(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_ECC_ElGamal_EncDec(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_ECC_ImportExportKeyPair(DxUint32_t* msg);

/******************* DH *********************************/
/*********************************************************/

/* HOST DH TEST COMMAND */

/* offsets of the parameters inside message */
#define DX_EXT_SEP_HOST_DH_GENERATORSIZE_IN_OFFSET		(DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DH_GENERATORSIZE_IN_OFFSET)
#define DX_EXT_SEP_HOST_DH_PRIMESIZE_IN_OFFSET			(DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DH_PRIMESIZE_IN_OFFSET)
#define DX_EXT_SEP_HOST_DH_QSIZE_IN_OFFSET              (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DH_QSIZE_IN_OFFSET)
#define DX_EXT_SEP_HOST_DH_L_IN_OFFSET                  (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DH_L_IN_OFFSET)
#define DX_EXT_SEP_HOST_DH_SecretDataGenType_IN_OFFSET  (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DH_SecretDataGenType_IN_OFFSET)
#define DX_EXT_SEP_HOST_DH_KeyGetSecretKeyType_IN_OFFSET  (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DH_KeyGetSecretKeyType_IN_OFFSET)
#define DX_EXT_SEP_HOST_DH_KeyLenInBits_IN_OFFSET         (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DH_KeyLenInBits_IN_OFFSET)
#define DX_EXT_SEP_HOST_DH_GENERATOR_OFFSET             (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_DH_GENERATOR_OFFSET)

/* all buffers has the same maximal length = max modulus size = DH_BufferMaxLength/4 */
#define DX_EXT_SEP_HOST_DH_PRIME_OFFSET					DX_EXT_SEP_HOST_DH_GENERATOR_OFFSET + DH_BufferMaxLength/4
#define DX_EXT_SEP_HOST_DH_Q_OFFSET                     DX_EXT_SEP_HOST_DH_PRIME_OFFSET + DH_BufferMaxLength/4 


/* offset to put return parameter */
#define DX_SEP_HOST_SEP_DH_MSG_RPLY_DATA_OUT_OFFSET		DX_SEP_HOST_SEP_BASE_MSG_OFFSET

/* DH functions */
DxUint32_t DX_SEP_PARSER_DH_PKCS3(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_DH_ANSI942(DxUint32_t* msg);

/******************* RND *********************************/
/*********************************************************/

/* HOST RND TEST COMMAND */

/* offsets of the parameters inside message */
#define DX_EXT_SEP_HOST_RND_SIZE_IN_OFFSET		(DX_SEP_HOST_SEP_BASE_MSG_OFFSET + DX_SEP_HOST_RND_SIZE_IN_OFFSET)

/* offset to put return parameter */
#define DX_SEP_HOST_SEP_DH_MSG_RPLY_DATA_OUT_OFFSET		DX_SEP_HOST_SEP_BASE_MSG_OFFSET

/* RND functions */
DxUint32_t DX_SEP_PARSER_RND_No_Reset(DxUint32_t* msg);
DxUint32_t DX_SEP_PARSER_RND_Reset(DxUint32_t* msg);

#endif

